﻿using Newtonsoft.Json;
using System.Collections.Generic;
using System.Net.Http;
using System.Threading.Tasks;
using System;

namespace LapperThreads
{
    public class LFSRestAPI
    {
        public static async Task<List<ModCarEntry>> GetModdedCars(string RestclientID, string RestclientSecret)
        {
            /*just a few warning messages*/
            if (string.IsNullOrWhiteSpace(RestclientSecret))
            {
                Console.WriteLine("ClientSecret Empty");
            }
            if (string.IsNullOrWhiteSpace(RestclientID))
            {
                Console.WriteLine("ClientID Empty");
            }

            var client = new HttpClient();
            var content = new FormUrlEncodedContent(new Dictionary<string, string>
            {
                {"client_secret",  RestclientSecret },
                {"client_id", RestclientID },
                {"grant_type", "client_credentials"}
            });
            var tokenResponse = await client.PostAsync("https://id.lfs.net/oauth2/access_token", content);
            var tokenText = await tokenResponse.Content.ReadAsStringAsync();
            var tokenObject = JsonConvert.DeserializeObject<TokenResponse>(tokenText);
            var accessToken = tokenObject.access_token;

            client.DefaultRequestHeaders.Add("Authorization", "Bearer " + accessToken);

            var carEntriesResponse = await client.GetStringAsync("https://api.lfs.net/vehiclemod/");
            return JsonConvert.DeserializeObject<ModCarEntriesResponse>(carEntriesResponse).Data;
        }

        public class TokenResponse
        {
            public string token_type { get; set; }
            public int expires_in { get; set; }
            public string access_token { get; set; }
        }

        public class ModCarEntriesResponse
        {
            public List<ModCarEntry> Data { get; set; }
        }

        public class ModCarEntry
        {
            public string id { get; set; }
            public string name { get; set; }
            public string descriptionShort { get; set; }
            public string description { get; set; }
            public int userId { get; set; }
            public string userName { get; set; }
            public bool wip { get; set; }
            public int publishedAt { get; set; }
            public int numDownloads { get; set; }
            public int curUsage { get; set; }
            public float rating { get; set; }
            public int numRatings { get; set; }
            public int version { get; set; }
            public int lastDownloadedAt { get; set; }
            public int _class { get; set; }
            public bool ev { get; set; }
        }
    }
}